/*
 * kintone-mfinvoice-subcontracting.js
 * Copyright (c) 2021 StrategIT
 *
 * Licensed under the MIT License
 */

(function() {
  'use strict';
  var recordFieldShown = function(event) {
    kintone.app.record.setFieldShown('partner_id', false);
    kintone.app.record.setFieldShown('department_id', false);
    kintone.app.record.setFieldShown('name_partner_copy', false);
    kintone.app.record.setFieldShown('related', false);
  };

  var recordDisabled = function(event) {
    var record = event.record;
    record.send_status.disabled = true;
  };

  var recordSentDisabled = function(event) {
    var record = event.record;
    record.document_name.disabled = record.send_status.value !== '未送信';
    record.name_partner.disabled = record.send_status.value !== '未送信';
    record.name.disabled = record.send_status.value !== '未送信';
    record.mail.disabled = record.send_status.value !== '未送信';
    record.password.disabled = record.send_status.value !== '未送信';
    record.pdf.disabled = record.send_status.value !== '未送信';
    record.authorizers_mail.disabled = record.send_status.value !== '未送信';
    record.browsers_mail.disabled = record.send_status.value !== '未送信';
    record.pdf.disabled = record.send_status.value !== '未送信';
  };

  var recordClear = function(event) {
    var record = event.record;
    record.send_status.value = '未送信';
    record.related.value = [];
  };

  kintone.events.on([
    'app.record.create.show',
  ], function(event) {
    recordClear(event);
  });

  kintone.events.on([
    'app.record.create.show',
    'app.record.edit.show',
    'app.record.index.edit.show'
  ], function(event) {
    recordDisabled(event);
    recordSentDisabled(event);
    recordFieldShown(event);
    return event;
  });

  kintone.events.on([
    'app.record.detail.show'
  ], function(event) {
    recordFieldShown(event);
  });
})();