/*
 * kintone-mfinvoice-target.js
 * Copyright (c) 2021 StrategIT
 *
 * Licensed under the MIT License
 */
(function() {
  'use strict';
  var targetName = function(event) {
    var target_name_label;
    var target_name_disp_link_label;
    var target_name_display;
    var target_name;
    var target_name_disp_URL;
    var link_text;
    var name_last = event.record.name_last.value ? event.record.name_last.value : '';
    var name_first = event.record.name_first.value ? event.record.name_first.value : '';
    target_name_label = document.createElement('div');
    target_name_disp_link_label = kintone.app.record.getSpaceElement('target_name_display').appendChild(target_name_label);
    target_name_disp_link_label.id = 'target_name_label';
    target_name_disp_link_label.innerText = 'ターゲット名';
    target_name_display = document.createElement('a');
    target_name = event.record.target_name.value ? event.record.target_name.value : '';
    if (target_name) {
      link_text = name_last + name_first ? name_last + ' ' + name_first : target_name;
      target_name_disp_URL = kintone.app.record.getSpaceElement('target_name_display').appendChild(target_name_display);
      target_name_disp_URL.href = target_name;
      target_name_disp_URL.target = '_blank';
      target_name_disp_URL.rel = 'noopener noreferrer';
      target_name_disp_URL.innerText = link_text;
    }
    return event;
  };
  var linkDisplay = function(event) {
    kintone.app.record.setFieldShown('target_name', false);
    targetName(event);
    return event;
  };

  // リンクをテキスト表示
  kintone.events.on([
    'app.record.detail.show',
  ], function(event) {
    linkDisplay(event);
    return event;
  });
})();