/*
 * kintone-mfinvoice-partner.js
 * Copyright (c) 2021 StrategIT
 *
 * Licensed under the MIT License
 */
(function() {
  'use strict';

  var validateErrorClear = function(event) {
    var record = event.record;
    var index, row;
    event.error = '';
    record.memo.error = '';
    for (index = 0; index < record.department.value.length; index++) {
      row = record.department.value[index].value;
      row.zip.error = '';
      row.tel.error = '';
      row.email.error = '';
      row.cc_emails.error = '';
    }
  };

  var validateTel = function(value) {
    /**
     * 電話番号バリデーションルール
     * 使用可能文字は0～9と-のみ
     * 数字は7～13桁
     * -は2つまで
     * -が2つの場合は、連続数字が2～4桁になってなければならない（この場合最後だけ5桁はok）
     * -で区切った場合、数字が1桁以下になってはならない
     */
    var numberReplace, telSplit, index;
    if (value) {
      if (/[^0-9-]/.test(value)) {
        return false;
      }
      numberReplace = value.replace(/[^0-9]/g, '');
      if (numberReplace.length < 7 || numberReplace.length > 13) {
        return false;
      }
      telSplit = value.split('-');
      if (telSplit.length > 3) {
        return false;
      } else if (telSplit.length === 3) {
        for (index = 0; index < telSplit.length; index++) {
          if (telSplit[index].length < 2 || telSplit[index].length > 5) {
            return false;
          } else if (index < 2 && telSplit[index].length > 4) {
            return false;
          }
        }
      } else if (telSplit.length === 2) {
        for (index = 0; index < telSplit.length; index++) {
          if (telSplit[index].length < 2) {
            return false;
          }
        }
      }
    }
    return true;
  };

  var validateMail = function(value) {
    var mailSplit, beforeString, afterString;
    if (value) {
      mailSplit = value.split('@');
      if (mailSplit.length !== 2) {
        return false;
      }
      beforeString = mailSplit[0];
      afterString = mailSplit[1];
      // 連続の.や最初と最後に.がある場合はfalse
      if (beforeString.indexOf('..') >= 0 || afterString.indexOf('..') >= 0) {
        return false;
      }
      if (beforeString.indexOf('.') === 0 || beforeString.lastIndexOf('.') === (beforeString.length - 1)) {
        return false;
      }
      if (afterString.indexOf('.-') >= 0 || afterString.indexOf('-.') >= 0) {
        return false;
      }
      if (afterString.indexOf('.') === -1) {
        return false;
      }
      if (!/^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+$/.test(beforeString)) {
        return false;
      }
      if (!/^[a-zA-Z0-9]+[a-zA-Z0-9.-]+[a-zA-Z]+$/.test(afterString)) {
        return false;
      }
      // .が一つのときのみ最後の.の後は英字のみ
      if (afterString.split('.').length === 2 && !/\.[a-zA-Z][^.]*$/.test(afterString)) {
        return false;
      }
    }
    return true;
  };
  var validateTable = function(event) {
    var record = event.record;
    var index, row, cc_emails, emailIndex;
    for (index = 0; index < record.department.value.length; index++) {
      row = record.department.value[index].value;
      if (row.zip.value && !/^[0-9]{3}-{0,1}[0-9]{4}$/.test(row.zip.value)) {
        row.zip.error = '郵便番号の形式が正しくありません。';
      }
      if (!validateTel(row.tel.value)) {
        row.tel.error = '電話番号の形式が正しくありません。';
      }
      if (row.email.value) {
        if (row.email.value.length > 255) {
          row.email.error = 'メールアドレスは255文字以内で入力してください。';
        } else if (!validateMail(row.email.value)) {
          row.email.error = '正しいEメールアドレスを入力してください。';
        }
      }
      if (row.cc_emails.value) {
        cc_emails = row.cc_emails.value.split(',');
        if (cc_emails.length > 10) {
          row.cc_emails.error = '「,」(半角カンマ)区切りで10件まで指定できます。';
        } else if (row.cc_emails.value.length > 500) {
          row.cc_emails.error = 'CCメールアドレスは500文字以内で入力してください。';
        }
        for (emailIndex = 0; emailIndex < cc_emails.length; emailIndex++) {
          if (!validateMail(cc_emails[emailIndex])) {
            row.cc_emails.error = '【' + (emailIndex + 1) + '番目】正しいEメールアドレスを入力してください。';
            break;
          }
        }
      }
      if (row.zip.error || row.tel.error || row.email.error || row.cc_emails.error) {
        event.error = '入力内容にエラーがあるため保存できません。';
      }
    }
  };

  var validateRecord = function(event) {
    var record = event.record;
    if (record.memo.value && record.memo.value.length > 500) {
      record.memo.error = '501文字より短くなければなりません。';
    }
    if (record.memo.error) {
      event.error = '入力内容にエラーがあるため保存できません。';
    }
  };

  kintone.events.on([
    'app.record.create.submit',
    'app.record.edit.submit',
    'app.record.index.edit.submit'
  ], function(event) {
    validateErrorClear(event);
    validateRecord(event);
    validateTable(event);
    return event;
  });
})();