/*
 * kintone-mfinvoice-target.js
 * Copyright (c) 2021 StrategIT
 *
 * Licensed under the MIT License
 */
(function() {
  'use strict';
  var validateRecord = function(event) {
    var record = event.record;
    var plan_tag_regex = /[A-Z]/;
    var plan_tag_value = record.plan_tag.value;
    if (record.plan_tag.value && plan_tag_value.match(plan_tag_regex)) {
      record.plan_tag.error = '企画タグにアルファベットの大文字は使用できません。';
    }
    if (record.plan_tag.error) {
      event.error = '入力内容にエラーがあるため保存できません。';
    }
  };

  var validateErrorClear = function(event) {
    var record = event.record;
    event.error = '';
    record.plan_tag.error = '';
  };

  kintone.events.on([
    'app.record.create.submit',
    'app.record.edit.submit',
    'app.record.index.edit.submit'
  ], function(event) {
    validateErrorClear(event);
    validateRecord(event);
    return event;
  });
})();