/*
 * kintone-mfinvoice-target.js
 * Copyright (c) 2021 StrategIT
 *
 * Licensed under the MIT License
 */

(function() {
  'use strict';

  var tableClear = function(event) {
    var plan_tag_list = event.record.plan_tags;
    var reaction_tag_list = event.record.reaction_tags;
    // 新規作成時
    if (plan_tag_list.value.length === 1) {
      if (plan_tag_list.value[0].id === null) {
        plan_tag_list.value = [];
      }
    }
    if (reaction_tag_list.value.length === 1) {
      if (reaction_tag_list.value[0].id === null) {
        reaction_tag_list.value = [];
      }
    }
    // 編集時テーブルレコード0の時
    if (plan_tag_list.value.length === 0) {
      plan_tag_list.value = [];
    }
    if (reaction_tag_list.value.length === 0) {
      reaction_tag_list.value = [];
    }
  };

  var recordDisabled = function(event) {
    var record = event.record;
    record.score.disabled = true;
    record.is_hot.disabled = true;
  };

  var tableDisabled = function(event) {
    var index, row;
    for (index = 0; index < event.record.plan_tags.value.length; index++) {
      row = event.record.plan_tags.value[index].value;
      row.plan_tags_name.disabled = true;
    }
    for (index = 0; index < event.record.reaction_tags.value.length; index++) {
      row = event.record.reaction_tags.value[index].value;
      row.reaction_tags_name.disabled = true;
    }
    return event;
  };

  var tableHide = function(event) {
    var plan_tags = event.record.plan_tags;
    var reaction_tags = event.record.reaction_tags;
    // 編集時テーブルレコード0の時
    if (plan_tags.value.length === 0) {
      kintone.app.record.setFieldShown('plan_tags', false);
    }
    if (reaction_tags.value.length === 0) {
      kintone.app.record.setFieldShown('reaction_tags', false);
    }
  };

  var validateRecord = function(event) {
    var record = event.record;
    var zip_regex = /^[0-9][0-9-]{1,8}[0-9]$/;
    var name_kana_regex = /[^あ-ん]/;
    var tel_regex = /^[0-9]+[0-9-()]{1,}[0-9]$/;
    if (record.zip.value && !(record.zip.value.match(zip_regex))) {
      record.zip.error = '郵便番号は数字とハイフンで10桁以内の組み合わせで入力してください。';
    }
    if (record.name_kana_last.value && (record.name_kana_last.value.match(name_kana_regex))) {
      record.name_kana_last.error = '姓（かな）はひらがなで入力してください。';
    }
    if (record.name_kana_first.value && (record.name_kana_first.value.match(name_kana_regex))) {
      record.name_kana_first.error = '名（かな）はひらがなで入力してください。';
    }
    if (record.tel.value && !(record.tel.value.match(tel_regex))) {
      record.tel.error = '電話番号は()および数字とハイフンの組み合わせで入力してください。';
    }
    if (record.mobile.value && !(record.mobile.value.match(tel_regex))) {
      record.mobile.error = '携帯番号は()および数字とハイフンの組み合わせで入力してください。';
    }
    if (record.fax.value && !(record.fax.value.match(tel_regex))) {
      record.fax.error = 'FAX番号は()および数字とハイフンの組み合わせで入力してください。';
    }
    if (record.zip.error || record.name_kana_last.error || record.name_kana_first.error
      || record.tel.error || record.mobile.error || record.fax.error) {
      event.error = '入力内容にエラーがあるため保存できません。';
    }
  };

  var validateErrorClear = function(event) {
    var record = event.record;
    event.error = '';
    record.zip.error = '';
    record.name_kana_last.error = '';
    record.name_kana_first.error = '';
    record.tel.error = '';
    record.mobile.error = '';
    record.fax.error = '';
  };

  kintone.events.on([
    'app.record.create.show',
    'app.record.edit.show',
    'app.record.index.edit.show'
  ], function(event) {
    recordDisabled(event);
    tableDisabled(event);
    return event;
  });

  kintone.events.on([
    'app.record.edit.show',
    'app.record.index.edit.show',
    'app.record.edit.change.plan_tags',
    'app.record.edit.change.reaction_tags',
    'app.record.index.edit.change.plan_tags',
    'app.record.index.edit.change.reaction_tags'
  ], function(event) {
    tableHide(event);
    return event;
  });

  kintone.events.on([
    'app.record.create.submit',
    'app.record.edit.submit'
  ], function(event) {
    tableClear(event);
    return event;
  });

  // ボタン設置
  kintone.events.on('app.record.detail.show', function(event) {
    var createPartnerAppButton;
    var update_param, partner_id, partner_record;
    var partner_url, partner_index, link;
    var record = event.record;
    var name = record.name_last.value + record.name_first.value;
    var address = record.address_city.value + record.address_street.value;
    if (document.getElementById('create_partner_app_button') !== null) {
      return;
    }
    if (record.company_name.value) {
      createPartnerAppButton = document.createElement('button');
      createPartnerAppButton.id = 'create_partner_app_button';
      createPartnerAppButton.innerText = '取引先登録ボタン';
      createPartnerAppButton.classList.add('kintoneplugin-button-normal');
      createPartnerAppButton.classList.add('create_partner_app_button');
      createPartnerAppButton.onclick = function() {
        partner_id = window.kintoneMfinvoiceInvoice.PARTNER_APP_ID;
        partner_record = {
          'name': {
            value: record.company_name.value
          },
          'department': {
            value: [
              {
                value: {
                  'department_name': {
                    value: record.division.value
                  },
                  'person_title': {
                    value: record.title.value
                  },
                  'person_name': {
                    value: name
                  },
                  'zip': {
                    value: record.zip.value
                  },
                  'tel': {
                    value: record.tel.value
                  },
                  'prefecture': {
                    value: record.pref_name.value
                  },
                  'address1': {
                    value: address
                  },
                  'address2': {
                    value: record.address_bldg.value
                  },
                  'email': {
                    value: record.mail.value
                  },
                  'cc_emails': {
                    value: record.sales_mail.value
                  }
                }
              }
            ]
          }
        };
        update_param = {
          'app': partner_id,
          'record': partner_record
        };
        kintone.api(kintone.api.url('/k/v1/record.json', true), 'POST', update_param).then(function(resp) {
          partner_url = kintone.api.url('/k/', true);
          partner_index = partner_url.indexOf('.json');
          link = partner_url.slice(0, partner_index) + partner_id + '/show#record=' + resp.id;
          window.location.href = link;
          window.alert('登録が完了しました');
        });
      };
      kintone.app.record.getHeaderMenuSpaceElement().appendChild(createPartnerAppButton);
    }
  });

  kintone.events.on([
    'app.record.create.submit',
    'app.record.edit.submit',
    'app.record.index.edit.submit'
  ], function(event) {
    validateErrorClear(event);
    validateRecord(event);
    return event;
  });
})();